DROP TABLE IF EXISTS `domains`;
CREATE TABLE `domains` (
                           `id` int NOT NULL AUTO_INCREMENT,
                           `customer_id` int DEFAULT NULL,
                           `registrar_id` int DEFAULT NULL,
                           `name` varchar(255) NOT NULL,
                           `renewal_date` date DEFAULT NULL,
                           `period` varchar(50) DEFAULT NULL,
                           `price` decimal(10,2) DEFAULT NULL,
                           `currency_id` int NOT NULL DEFAULT '0',
                           `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
                           `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                           PRIMARY KEY (`id`),
                           KEY `currency_id` (`currency_id`),
                           KEY `domains_user_id_fk` (`customer_id`),
                           KEY `domains_registrars_id_fk` (`registrar_id`),
                           CONSTRAINT `domains_currency_id_fk` FOREIGN KEY (`currency_id`) REFERENCES `currency` (`id`),
                           CONSTRAINT `domains_registrars_id_fk` FOREIGN KEY (`registrar_id`) REFERENCES `registrars` (`id`),
                           CONSTRAINT `domains_user_id_fk` FOREIGN KEY (`customer_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;