DROP TABLE IF EXISTS `hosts`;
CREATE TABLE `hosts` (
                         `id` int NOT NULL AUTO_INCREMENT,
                         `customer_id` int DEFAULT NULL,
                         `currency_id` int NOT NULL DEFAULT '0',
                         `registrar_id` int DEFAULT NULL,
                         `period` varchar(50) DEFAULT NULL,
                         `name` varchar(255) NOT NULL,
                         `price` decimal(10,2) DEFAULT NULL,
                         `ip_address` varchar(45) NOT NULL,
                         `renewal_date` date DEFAULT NULL,
                         `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
                         `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                         PRIMARY KEY (`id`),
                         KEY `customer_id` (`customer_id`),
                         KEY `hosts_currency_id_index` (`currency_id`),
                         CONSTRAINT `hosts_currency_id_fk` FOREIGN KEY (`currency_id`) REFERENCES `currency` (`id`),
                         CONSTRAINT `hosts_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `user` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_0900_ai_ci;