DROP TABLE IF EXISTS `product_discount`;
CREATE TABLE `product_discount` (
                                    `id` int NOT NULL AUTO_INCREMENT,
                                    `product_id` int NOT NULL,
                                    `user_group_id` int NOT NULL,
                                    `quantity` int NOT NULL DEFAULT '0',
                                    `priority` int NOT NULL DEFAULT '1',
                                    `price` decimal(15,4) NOT NULL DEFAULT '0.0000',
                                    `date_start` date DEFAULT NULL,
                                    `date_end` date DEFAULT NULL,
                                    PRIMARY KEY (`id`),
                                    KEY `fk_product_discount_id` (`product_id`),
                                    CONSTRAINT `fk_product_discount_id` FOREIGN KEY (`product_id`) REFERENCES `product_list` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb3;