DROP TABLE IF EXISTS `product_list_desc`;
CREATE TABLE `product_list_desc` (
                                     `id` int NOT NULL AUTO_INCREMENT,
                                     `product_list_id` int NOT NULL,
                                     `language_id` int NOT NULL,
                                     `name` varchar(255) NOT NULL,
                                     `short_name` varchar(60) DEFAULT NULL,
                                     `description` text,
                                     `meta_title` varchar(255) NOT NULL,
                                     `meta_description` varchar(255) NOT NULL,
                                     `meta_keyword` varchar(255) NOT NULL,
                                     `tags` varchar(255) NOT NULL,
                                     `seo_url` varchar(255) NOT NULL,
                                     `invoice_title` varchar(250) DEFAULT NULL,
                                     PRIMARY KEY (`id`),
                                     KEY `product_desc_list_id` (`product_list_id`),
                                     FULLTEXT KEY `name` (`name`),
                                     CONSTRAINT `fk_list_desc_list_id` FOREIGN KEY (`product_list_id`) REFERENCES `product_list` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb3;