DROP TABLE IF EXISTS `product_list_option_values`;
CREATE TABLE `product_list_option_values` (
                                              `id` int NOT NULL AUTO_INCREMENT,
                                              `product_list_id` int NOT NULL,
                                              `product_option_id` int NOT NULL,
                                              `product_option_value_id` int DEFAULT NULL,
                                              `value` varchar(155) DEFAULT NULL,
                                              `name` varchar(155) DEFAULT NULL,
                                              `image` varchar(155) DEFAULT NULL,
                                              `price` decimal(15,4) NOT NULL,
                                              `barcode` varchar(15) NOT NULL,
                                              `quantity` int NOT NULL,
                                              `sort` int DEFAULT '0',
                                              `stock_down` tinyint(1) NOT NULL DEFAULT '0',
                                              `parent_id` int DEFAULT NULL,
                                              `new_parent_id` int DEFAULT NULL,
                                              `xml_id` varchar(55) DEFAULT NULL,
                                              PRIMARY KEY (`id`),
                                              KEY `fk_product_list_option_value_id_` (`product_option_value_id`) USING BTREE,
                                              CONSTRAINT `product_list_option_values_product_option_values_id_fk` FOREIGN KEY (`product_option_value_id`) REFERENCES `product_option_values` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb3;