DROP TABLE IF EXISTS `product_list_options`;
CREATE TABLE `product_list_options` (
                                        `id` int NOT NULL AUTO_INCREMENT,
                                        `product_list_id` int NOT NULL,
                                        `product_options_id` int NOT NULL,
                                        `product_sub_option_id` int NOT NULL,
                                        `product_main_option_id` int NOT NULL DEFAULT '0',
                                        `required` tinyint(1) NOT NULL DEFAULT '0',
                                        PRIMARY KEY (`id`),
                                        KEY `fk_product_list_options_id` (`product_list_id`),
                                        KEY `fk_ref_product_list_options_id_id` (`product_options_id`),
                                        CONSTRAINT `fk_product_list_options_id` FOREIGN KEY (`product_list_id`) REFERENCES `product_list` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
                                        CONSTRAINT `fk_product_list_options_id_id` FOREIGN KEY (`product_options_id`) REFERENCES `product_options` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
                                        CONSTRAINT `fk_ref_product_list_options_id_id` FOREIGN KEY (`product_options_id`) REFERENCES `product_options` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb3;