DROP TABLE IF EXISTS `product_list_users`;
CREATE TABLE `product_list_users` (
                                      `product_list_id` int NOT NULL,
                                      `user_id` int NOT NULL,
                                      `price` decimal(15,6) NOT NULL,
                                      `buying_price` decimal(15,4) NOT NULL,
                                      `special_price` decimal(15,6) NOT NULL,
                                      `quantity` int NOT NULL,
                                      `min_stock` int NOT NULL,
                                      `status` tinyint(1) NOT NULL DEFAULT '0',
                                      `valid` tinyint(1) NOT NULL DEFAULT '0',
                                      `is_new` tinyint(1) NOT NULL DEFAULT '0',
                                      `is_bestseller` tinyint(1) NOT NULL DEFAULT '0',
                                      `is_special` tinyint(1) NOT NULL DEFAULT '0',
                                      `is_sales` tinyint(1) NOT NULL DEFAULT '0',
                                      `is_reseller` tinyint(1) NOT NULL DEFAULT '0',
                                      `insert_date` datetime NOT NULL,
                                      `edit_date` datetime NOT NULL,
                                      KEY `product_list_user` (`product_list_id`),
                                      CONSTRAINT `product_list_user` FOREIGN KEY (`product_list_id`) REFERENCES `product_list` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;