DROP TABLE IF EXISTS `safe`;
CREATE TABLE `safe` (
                        `id` int NOT NULL AUTO_INCREMENT,
                        `user_id` int NOT NULL,
                        `operation_no` varchar(100) DEFAULT NULL,
                        `invoice` varchar(20) DEFAULT NULL COMMENT 'fatura,irsaliye,fis',
                        `invoice_no` varchar(100) DEFAULT NULL,
                        `invoice_id` int DEFAULT NULL,
                        `invoice_seri` varchar(10) DEFAULT NULL,
                        `invoice_type` varchar(50) DEFAULT NULL,
                        `special_code` varchar(100) DEFAULT NULL,
                        `safe_type` varchar(50) DEFAULT NULL COMMENT 'cash-nakit,cheque-cek,bill-senet',
                        `staff_code` varchar(100) DEFAULT NULL,
                        `safes_id` int NOT NULL,
                        `customer_id` int DEFAULT NULL,
                        `customer_title` varchar(150) DEFAULT NULL,
                        `move` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-Tahsilat, 1-Satış',
                        `currency_type` varchar(10) NOT NULL DEFAULT 'yerel' COMMENT 'yerel,doviz,euro',
                        `currency_code` varchar(5) NOT NULL DEFAULT 'TRY',
                        `currency` varchar(10) DEFAULT NULL,
                        `price` decimal(15,6) NOT NULL DEFAULT '0.000000',
                        `before_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
                        `total_price` decimal(15,4) NOT NULL DEFAULT '0.0000',
                        `currency_price` decimal(15,6) NOT NULL DEFAULT '0.000000',
                        `discount_price` decimal(15,6) NOT NULL DEFAULT '0.000000',
                        `description` text,
                        `safe_prefix` varchar(5) DEFAULT NULL COMMENT 'Alış(A),Bakiye(B)',
                        `safe_type_id` int DEFAULT NULL,
                        `payment_type` varchar(50) DEFAULT NULL,
                        `transfer_id` int DEFAULT NULL,
                        `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0- işlem görememiş,1- ödeme alınmış, 2- vadesi gelmemiş, 3- vadesi geçmiş',
                        `insert_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
                        `edit_date` datetime DEFAULT NULL,
                        PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb3;