DROP TABLE IF EXISTS `safe_customer`;
CREATE TABLE `safe_customer` (
                                 `id` int NOT NULL AUTO_INCREMENT,
                                 `user_id` int NOT NULL,
                                 `operation_no` varchar(100) NOT NULL,
                                 `invoice` varchar(20) NOT NULL COMMENT 'fatura,irsaliye,fis',
                                 `invoice_no` varchar(100) NOT NULL,
                                 `invoice_id` int NOT NULL,
                                 `invoice_seri` varchar(10) NOT NULL,
                                 `invoice_type` varchar(50) NOT NULL,
                                 `special_code` varchar(100) NOT NULL,
                                 `safe_type` varchar(50) NOT NULL COMMENT 'cash-nakit,cheque-cek,bill-senet',
                                 `item_id` int NOT NULL,
                                 `staff_code` varchar(100) NOT NULL,
                                 `safes_id` int NOT NULL,
                                 `customer_id` int NOT NULL,
                                 `customer_title` varchar(150) NOT NULL,
                                 `move` tinyint(1) NOT NULL DEFAULT '0' COMMENT '0-Tahsilat, 1-Satış',
                                 `currency` varchar(50) NOT NULL,
                                 `currency_type` varchar(10) NOT NULL DEFAULT 'yerel' COMMENT 'yerel,doviz,euro',
                                 `currency_code` varchar(5) NOT NULL DEFAULT 'TRY',
                                 `price` decimal(15,6) NOT NULL,
                                 `before_price` decimal(15,4) NOT NULL,
                                 `total_price` decimal(15,4) NOT NULL,
                                 `currency_price` decimal(15,6) NOT NULL,
                                 `discount_price` decimal(15,6) NOT NULL,
                                 `description` text NOT NULL,
                                 `safe_prefix` varchar(5) NOT NULL COMMENT 'Alış(A),Bakiye(B)',
                                 `safe_type_id` int NOT NULL,
                                 `payment_type` varchar(50) NOT NULL,
                                 `status` tinyint(1) NOT NULL DEFAULT '1' COMMENT '0- işlem görememiş,1- ödeme alınmış, 2- vadesi gelmemiş, 3- vadesi geçmiş',
                                 `insert_date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
                                 `edit_date` datetime NOT NULL,
                                 PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb3;