DROP TABLE IF EXISTS `sales`;
CREATE TABLE `sales` (
                         `id` int NOT NULL AUTO_INCREMENT,
                         `customer_id` int DEFAULT NULL,
                         `user_id` int DEFAULT NULL,
                         `insert_id` int DEFAULT NULL,
                         `firstname` varchar(50) DEFAULT NULL,
                         `lastname` varchar(50) DEFAULT NULL,
                         `telephone` varchar(11) DEFAULT NULL,
                         `email` varchar(50) DEFAULT NULL,
                         `invoice_firstname` varchar(50) DEFAULT NULL,
                         `invoice_lastname` varchar(50) DEFAULT NULL,
                         `invoice_company` varchar(100) DEFAULT NULL,
                         `invoice_tax_office` varchar(50) DEFAULT NULL,
                         `invoice_tax_number` varchar(20) DEFAULT NULL,
                         `invoice_tc_number` varchar(11) DEFAULT NULL,
                         `invoice_country_id` int DEFAULT NULL,
                         `invoice_district_id` int DEFAULT NULL,
                         `invoice_zone_id` int DEFAULT NULL,
                         `invoice_quarter_id` int DEFAULT NULL,
                         `invoice_address` text,
                         `shipping_firstname` varchar(50) DEFAULT NULL,
                         `shipping_lastname` varchar(50) DEFAULT NULL,
                         `shipping_company` varchar(100) DEFAULT NULL,
                         `shipping_tax_office` varchar(50) DEFAULT NULL,
                         `shipping_tax_number` varchar(20) DEFAULT NULL,
                         `shipping_tc_number` varchar(11) DEFAULT NULL,
                         `shipping_country_id` int DEFAULT NULL,
                         `shipping_district_id` int DEFAULT NULL,
                         `shipping_zone_id` int DEFAULT NULL,
                         `shipping_quarter_id` int DEFAULT NULL,
                         `shipping_address` text,
                         `note` text,
                         `payment_method_code` varchar(20) DEFAULT NULL,
                         `payment_method` varchar(50) DEFAULT NULL,
                         `shipping_method_code` varchar(20) DEFAULT NULL,
                         `shipping_method` varchar(50) DEFAULT NULL,
                         `total_price` decimal(15,4) DEFAULT NULL,
                         `full_total_price` decimal(15,6) DEFAULT NULL,
                         `date_added` datetime DEFAULT NULL,
                         `date_edit` datetime DEFAULT NULL,
                         `readed` tinyint(1) DEFAULT '0',
                         `status` tinyint(1) DEFAULT NULL,
                         `shop_id` int DEFAULT NULL,
                         `staff_id` int DEFAULT NULL,
                         `order_status_id` int DEFAULT NULL,
                         `order_shop_id` int DEFAULT NULL,
                         `currency_code` varchar(10) DEFAULT NULL,
                         `currency_value` decimal(15,4) DEFAULT NULL,
                         `tax_id` int DEFAULT NULL,
                         `tax_value` float DEFAULT NULL,
                         `payment_type` varchar(10) DEFAULT 'normal' COMMENT 'normal,company,quicksafe',
                         `ship_barcode_send` tinyint(1) DEFAULT '0',
                         `ship_barcode_code` varchar(155) DEFAULT NULL,
                         `ship_barcode_tracking_id` varchar(155) DEFAULT NULL,
                         `paying_status_id` int DEFAULT NULL,
                         `invoice_status` tinyint(1) DEFAULT NULL COMMENT '0 - Hic girilmemiş, 1- Fatura Kesilmiş, 2 - Faturada Hata Oluşmuş',
                         `invoice_error` text,
                         `guid` varchar(100) DEFAULT NULL,
                         `ip` varchar(20) DEFAULT NULL,
                         `session_id` varchar(150) DEFAULT NULL,
                         `sms_alert` tinyint(1) DEFAULT '0',
                         `mail_alert` tinyint(1) DEFAULT '0',
                         `payment_ref_id` varchar(150) DEFAULT NULL,
                         `payment_order_id` varchar(150) DEFAULT NULL,
                         `bank_code` varchar(50) DEFAULT NULL,
                         `warehouse_id` int DEFAULT NULL,
                         `multiple_sale_id` int DEFAULT NULL COMMENT 'Çoklu sipariş ana id',
                         `column_name` int DEFAULT NULL,
                         `is_multiple` tinyint DEFAULT '0' COMMENT 'Çoklu sipariş mi ',
                         PRIMARY KEY (`id`),
                         KEY `sales_shop` (`shop_id`),
                         KEY `sales_status` (`order_status_id`),
                         KEY `payment_status_id` (`paying_status_id`),
                         KEY `zone_id_sale` (`invoice_zone_id`),
                         KEY `country_id_sale` (`invoice_country_id`),
                         CONSTRAINT `payment_status` FOREIGN KEY (`paying_status_id`) REFERENCES `statuses` (`id`),
                         CONSTRAINT `sales_shop` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`),
                         CONSTRAINT `sales_shops` FOREIGN KEY (`shop_id`) REFERENCES `shops` (`id`),
                         CONSTRAINT `sales_status` FOREIGN KEY (`order_status_id`) REFERENCES `statuses` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb3;