DROP TABLE IF EXISTS `sales_products`;
CREATE TABLE `sales_products` (
                                  `id` int NOT NULL AUTO_INCREMENT,
                                  `sales_id` int NOT NULL,
                                  `product_id` int NOT NULL,
                                  `brand_id` int NOT NULL,
                                  `product_user_id` int DEFAULT '0',
                                  `code` varchar(15) DEFAULT NULL,
                                  `barcode` varchar(50) DEFAULT NULL,
                                  `name` varchar(155) DEFAULT NULL,
                                  `count` int DEFAULT '0',
                                  `rate` float DEFAULT '0',
                                  `discount` decimal(15,6) DEFAULT '0.000000',
                                  `quantity` int DEFAULT '0',
                                  `tax_id` int DEFAULT '0',
                                  `price` decimal(15,4) DEFAULT '0.0000',
                                  `prices` decimal(15,4) DEFAULT '0.0000' COMMENT 'KDV hariç birim fiyat',
                                  `price_tax` decimal(15,4) DEFAULT '0.0000',
                                  `total_price` decimal(15,4) DEFAULT '0.0000',
                                  `total` decimal(15,4) DEFAULT '0.0000',
                                  `options` text,
                                  `image` varchar(255) DEFAULT NULL,
                                  `shipping_code` varchar(50) DEFAULT NULL,
                                  `shipping_title` varchar(100) DEFAULT NULL,
                                  `shipping_price` decimal(15,6) DEFAULT '0.000000',
                                  `shipping_tax` decimal(15,6) DEFAULT '0.000000',
                                  `shipping_tax_id` int DEFAULT '0',
                                  `net_price` decimal(15,6) DEFAULT '0.000000',
                                  `new_price` decimal(15,6) DEFAULT '0.000000',
                                  `gift_quantity` int DEFAULT '0',
                                  `gift_quantity_for_teacher` int DEFAULT '0',
                                  `currency_id` int DEFAULT '0',
                                  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb3;