DROP TABLE IF EXISTS `shopping_cart`;
CREATE TABLE `shopping_cart` (
                                 `id` int NOT NULL AUTO_INCREMENT,
                                 `product_id` int NOT NULL,
                                 `user_id` int DEFAULT NULL,
                                 `product_user_id` int DEFAULT NULL,
                                 `brand_id` int DEFAULT NULL,
                                 `quantity` int NOT NULL,
                                 `gift_quantity` int DEFAULT '0',
                                 `gift_quantity_for_teacher` int DEFAULT '0',
                                 `new_price` decimal(15,6) DEFAULT '0.000000',
                                 `options` text,
                                 `ip` varchar(15) DEFAULT NULL,
                                 `session_id` varchar(50) DEFAULT NULL,
                                 `readed` tinyint(1) NOT NULL DEFAULT '0',
                                 `shop_id` int DEFAULT '0',
                                 `bid_id` int DEFAULT '0',
                                 `token` varchar(250) DEFAULT NULL,
                                 `date_added` datetime DEFAULT NULL,
                                 `date_edit` datetime DEFAULT NULL,
                                 PRIMARY KEY (`id`),
                                 KEY `porduct_id` (`product_id`) USING BTREE,
                                 CONSTRAINT `fk_name` FOREIGN KEY (`product_id`) REFERENCES `product_list` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb3;