DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
                        `id` int NOT NULL AUTO_INCREMENT,
                        `username` varchar(155) NOT NULL,
                        `full_name` varchar(150) NOT NULL,
                        `firstname` varchar(50) NOT NULL,
                        `lastname` varchar(50) NOT NULL,
                        `email` varchar(155) NOT NULL,
                        `telephone` varchar(15) NOT NULL,
                        `company_name` varchar(50) NOT NULL,
                        `company_address` varchar(150) NOT NULL,
                        `company_tax_office` varchar(50) NOT NULL,
                        `tax_number` bigint NOT NULL,
                        `friendship` tinyint(1) NOT NULL,
                        `password` varchar(255) NOT NULL,
                        `user_group_id` int NOT NULL,
                        `phone check` tinyint(1) NOT NULL,
                        `email check` tinyint(1) NOT NULL,
                        `roles` text NOT NULL COMMENT 'admin,company,customer,staff',
                        `status` tinyint(1) NOT NULL,
                        `readed` tinyint(1) NOT NULL DEFAULT '0',
                        `company_person_name` varchar(155) NOT NULL,
                        `company_person_lastname` varchar(155) NOT NULL,
                        `company_person_image` varchar(155) NOT NULL,
                        `cellphone` varchar(15) NOT NULL,
                        `company_email` varchar(50) NOT NULL,
                        `company_accounting_email` varchar(50) NOT NULL,
                        `company_sale_email` varchar(50) NOT NULL,
                        `country_id` int NOT NULL DEFAULT '215',
                        `country_name` varchar(50) NOT NULL,
                        `zone_id` int NOT NULL,
                        `zone_name` varchar(50) NOT NULL,
                        `district_id` int NOT NULL,
                        `district_name` varchar(50) NOT NULL,
                        `quarter_id` int NOT NULL,
                        `quarter_name` varchar(50) NOT NULL,
                        `company_location` varchar(150) NOT NULL,
                        `company_sicil_no` varchar(100) NOT NULL,
                        `company_mersis_no` varchar(100) NOT NULL,
                        `company_kep_address` varchar(100) NOT NULL,
                        `company_info` text NOT NULL,
                        `company_logo` varchar(100) NOT NULL,
                        `instagram` varchar(50) NOT NULL,
                        `date_added` datetime NOT NULL,
                        `shop_id` int NOT NULL DEFAULT '1',
                        `delete_status` tinyint(1) NOT NULL DEFAULT '0',
                        `file_status` tinyint(1) NOT NULL DEFAULT '0',
                        `company_file_ticaret` varchar(150) NOT NULL,
                        `company_file_vergi` varchar(150) NOT NULL,
                        `company_file_imza` varchar(150) NOT NULL,
                        `company_file_faaliyet` varchar(150) NOT NULL,
                        `company_file_yayinci` varchar(150) NOT NULL,
                        `person_population_image` varchar(200) NOT NULL,
                        `person_start_date` datetime NOT NULL,
                        `person_end_date` datetime NOT NULL,
                        `person_car_model` varchar(150) NOT NULL,
                        `person_car_year` varchar(4) NOT NULL,
                        `person_car_number` varchar(50) NOT NULL,
                        `person_car_policy_start` datetime NOT NULL,
                        `person_car_policy_end` datetime NOT NULL,
                        `person_car_special_policy_start` datetime NOT NULL,
                        `person_car_special_policy_end` datetime NOT NULL,
                        `token` varchar(255) NOT NULL,
                        `matching_status` tinyint(1) NOT NULL DEFAULT '0',
                        `twitter` varchar(150) NOT NULL,
                        `facebook` varchar(150) NOT NULL,
                        `youtube` varchar(150) NOT NULL,
                        `person_car_exam_start` datetime NOT NULL,
                        `person_car_exam_end` datetime NOT NULL,
                        `main_user_id` int NOT NULL,
                        `user_code` varchar(150) NOT NULL,
                        `insert_user_id` int NOT NULL,
                        `schooll_id` int NOT NULL,
                        `class_id` int NOT NULL,
                        `department_id` int NOT NULL,
                        `customer_group_id` int NOT NULL,
                        `car_id` int NOT NULL,
                        `address_id` int NOT NULL,
                        `event_id` int NOT NULL,
                        `is_publisher_bookstore` tinyint(1) NOT NULL DEFAULT '0',
                        `is_order` tinyint(1) NOT NULL DEFAULT '0',
                        `secret_mode` tinyint(1) NOT NULL DEFAULT '0',
                        `company_type` varchar(30) NOT NULL COMMENT 'Individual,PrivateCompany,Corporation',
                        `bank_name` varchar(150) NOT NULL,
                        `iban` varchar(26) NOT NULL,
                        `birth_date` date NOT NULL,
                        `uniq_id` varchar(150) NOT NULL,
                        `commission_rate` decimal(15,4) NOT NULL,
                        `uniqcode` varchar(150) NOT NULL,
                        `lang` int NOT NULL,
                        `salary` decimal(15,6) NOT NULL,
                        `address` text NOT NULL,
                        `note` text NOT NULL,
                        `bank_info` text NOT NULL,
                        `before_total` decimal(15,6) NOT NULL,
                        `total` decimal(15,6) NOT NULL,
                        `auto_invoice` tinyint(1) NOT NULL DEFAULT '1',
                        `invoice_rate` tinyint(1) NOT NULL DEFAULT '1',
                        `staff_id` int NOT NULL,
                        `edit_date` datetime NOT NULL,
                        `code1` varchar(50) NOT NULL,
                        `code2` varchar(50) NOT NULL,
                        `code3` varchar(50) NOT NULL,
                        `code4` varchar(50) NOT NULL,
                        `code5` varchar(50) NOT NULL,
                        `gib_invoice_mail` varchar(150) NOT NULL,
                        `invoice_type` enum('earsiv','efatura') DEFAULT NULL COMMENT 'earsiv,efatura',
                        `shipping_type` varchar(20) NOT NULL,
                        `shipping_company` varchar(20) NOT NULL,
                        `redirect` varchar(150) DEFAULT NULL,
                        PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb3;