DROP TABLE IF EXISTS `user`;

CREATE TABLE `user` (
                        `company_name` varchar(50) NOT NULL,
                        `user_group_id` int NOT NULL,
                        `status` tinyint(1) NOT NULL,
                        `delete_status` tinyint(1) NOT NULL DEFAULT '0'
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb3;

ALTER TABLE `user` ADD `company_address` varchar(150) NOT NULL AFTER `company_name`;
ALTER TABLE `user` ADD `company_tax_office` varchar(50) NOT NULL AFTER `company_address`;
ALTER TABLE `user` ADD `tax_number` bigint NOT NULL AFTER `company_tax_office`;
ALTER TABLE `user` ADD `friendship` tinyint(1) NOT NULL AFTER `tax_number`;
ALTER TABLE `user` ADD `phone check` tinyint(1) NOT NULL AFTER `user_group_id`;
ALTER TABLE `user` ADD `email check` tinyint(1) NOT NULL AFTER `phone check`;
ALTER TABLE `user` ADD `readed` tinyint(1) NOT NULL DEFAULT '0' AFTER `status`;
ALTER TABLE `user` ADD `company_person_name` varchar(155) NOT NULL AFTER `readed`;
ALTER TABLE `user` ADD `company_person_lastname` varchar(155) NOT NULL AFTER `company_person_name`;
ALTER TABLE `user` ADD `company_person_image` varchar(155) NOT NULL AFTER `company_person_lastname`;
ALTER TABLE `user` ADD `cellphone` varchar(15) NOT NULL AFTER `company_person_image`;
ALTER TABLE `user` ADD `company_email` varchar(50) NOT NULL AFTER `cellphone`;
ALTER TABLE `user` ADD `company_accounting_email` varchar(50) NOT NULL AFTER `company_email`;
ALTER TABLE `user` ADD `company_sale_email` varchar(50) NOT NULL AFTER `company_accounting_email`;
ALTER TABLE `user` ADD `country_id` int NOT NULL DEFAULT '215' AFTER `company_sale_email`;
ALTER TABLE `user` ADD `country_name` varchar(50) NOT NULL AFTER `country_id`;
ALTER TABLE `user` ADD `zone_id` int NOT NULL AFTER `country_name`;
ALTER TABLE `user` ADD `zone_name` varchar(50) NOT NULL AFTER `zone_id`;
ALTER TABLE `user` ADD `district_id` int NOT NULL AFTER `zone_name`;
ALTER TABLE `user` ADD `district_name` varchar(50) NOT NULL AFTER `district_id`;
ALTER TABLE `user` ADD `quarter_id` int NOT NULL AFTER `district_name`;
ALTER TABLE `user` ADD `quarter_name` varchar(50) NOT NULL AFTER `quarter_id`;
ALTER TABLE `user` ADD `company_location` varchar(150) NOT NULL AFTER `quarter_name`;
ALTER TABLE `user` ADD `company_sicil_no` varchar(100) NOT NULL AFTER `company_location`;
ALTER TABLE `user` ADD `company_mersis_no` varchar(100) NOT NULL AFTER `company_sicil_no`;
ALTER TABLE `user` ADD `company_kep_address` varchar(100) NOT NULL AFTER `company_mersis_no`;
ALTER TABLE `user` ADD `company_info` text NOT NULL AFTER `company_kep_address`;
ALTER TABLE `user` ADD `company_logo` varchar(100) NOT NULL AFTER `company_info`;
ALTER TABLE `user` ADD `instagram` varchar(50) NOT NULL AFTER `company_logo`;
ALTER TABLE `user` ADD `file_status` tinyint(1) NOT NULL DEFAULT '0' AFTER `delete_status`;
ALTER TABLE `user` ADD `company_file_ticaret` varchar(150) NOT NULL AFTER `file_status`;
ALTER TABLE `user` ADD `company_file_vergi` varchar(150) NOT NULL AFTER `company_file_ticaret`;
ALTER TABLE `user` ADD `company_file_imza` varchar(150) NOT NULL AFTER `company_file_vergi`;
ALTER TABLE `user` ADD `company_file_faaliyet` varchar(150) NOT NULL AFTER `company_file_imza`;
ALTER TABLE `user` ADD `company_file_yayinci` varchar(150) NOT NULL AFTER `company_file_faaliyet`;
ALTER TABLE `user` ADD `person_population_image` varchar(200) NOT NULL AFTER `company_file_yayinci`;
ALTER TABLE `user` ADD `person_start_date` datetime NOT NULL AFTER `person_population_image`;
ALTER TABLE `user` ADD `person_end_date` datetime NOT NULL AFTER `person_start_date`;
ALTER TABLE `user` ADD `person_car_model` varchar(150) NOT NULL AFTER `person_end_date`;
ALTER TABLE `user` ADD `person_car_year` varchar(4) NOT NULL AFTER `person_car_model`;
ALTER TABLE `user` ADD `person_car_number` varchar(50) NOT NULL AFTER `person_car_year`;
ALTER TABLE `user` ADD `person_car_policy_start` datetime NOT NULL AFTER `person_car_number`;
ALTER TABLE `user` ADD `person_car_policy_end` datetime NOT NULL AFTER `person_car_policy_start`;
ALTER TABLE `user` ADD `person_car_special_policy_start` datetime NOT NULL AFTER `person_car_policy_end`;
ALTER TABLE `user` ADD `person_car_special_policy_end` datetime NOT NULL AFTER `person_car_special_policy_start`;
ALTER TABLE `user` ADD `token` varchar(255) NOT NULL AFTER `person_car_special_policy_end`;
ALTER TABLE `user` ADD `matching_status` tinyint(1) NOT NULL DEFAULT '0' AFTER `token`;
ALTER TABLE `user` ADD `twitter` varchar(150) NOT NULL AFTER `matching_status`;
ALTER TABLE `user` ADD `facebook` varchar(150) NOT NULL AFTER `twitter`;
ALTER TABLE `user` ADD `youtube` varchar(150) NOT NULL AFTER `facebook`;
ALTER TABLE `user` ADD `person_car_exam_start` datetime NOT NULL AFTER `youtube`;
ALTER TABLE `user` ADD `person_car_exam_end` datetime NOT NULL AFTER `person_car_exam_start`;
ALTER TABLE `user` ADD `main_user_id` int NOT NULL AFTER `person_car_exam_end`;
ALTER TABLE `user` ADD `user_code` varchar(150) NOT NULL AFTER `main_user_id`;
ALTER TABLE `user` ADD `insert_user_id` int NOT NULL AFTER `user_code`;
ALTER TABLE `user` ADD `schooll_id` int NOT NULL AFTER `insert_user_id`;
ALTER TABLE `user` ADD `class_id` int NOT NULL AFTER `schooll_id`;
ALTER TABLE `user` ADD `department_id` int NOT NULL AFTER `class_id`;
ALTER TABLE `user` ADD `customer_group_id` int NOT NULL AFTER `department_id`;
ALTER TABLE `user` ADD `car_id` int NOT NULL AFTER `customer_group_id`;
ALTER TABLE `user` ADD `address_id` int NOT NULL AFTER `car_id`;
ALTER TABLE `user` ADD `event_id` int NOT NULL AFTER `address_id`;
ALTER TABLE `user` ADD `is_publisher_bookstore` tinyint(1) NOT NULL DEFAULT '0' AFTER `event_id`;
ALTER TABLE `user` ADD `is_order` tinyint(1) NOT NULL DEFAULT '0' AFTER `is_publisher_bookstore`;
ALTER TABLE `user` ADD `secret_mode` tinyint(1) NOT NULL DEFAULT '0' AFTER `is_order`;
ALTER TABLE `user` ADD `company_type` varchar(30) NOT NULL COMMENT 'Individual,PrivateCompany,Corporation' AFTER `secret_mode`;
ALTER TABLE `user` ADD `bank_name` varchar(150) NOT NULL AFTER `company_type`;
ALTER TABLE `user` ADD `iban` varchar(26) NOT NULL AFTER `bank_name`;
ALTER TABLE `user` ADD `birth_date` date NOT NULL AFTER `iban`;
ALTER TABLE `user` ADD `uniq_id` varchar(150) NOT NULL AFTER `birth_date`;
ALTER TABLE `user` ADD `commission_rate` decimal(15,4) NOT NULL AFTER `uniq_id`;
ALTER TABLE `user` ADD `uniqcode` varchar(150) NOT NULL AFTER `commission_rate`;
ALTER TABLE `user` ADD `lang` int NOT NULL AFTER `uniqcode`;
ALTER TABLE `user` ADD `salary` decimal(15,6) NOT NULL AFTER `lang`;
ALTER TABLE `user` ADD `address` text NOT NULL AFTER `salary`;
ALTER TABLE `user` ADD `note` text NOT NULL AFTER `address`;
ALTER TABLE `user` ADD `bank_info` text NOT NULL AFTER `note`;
ALTER TABLE `user` ADD `before_total` decimal(15,6) NOT NULL AFTER `bank_info`;
ALTER TABLE `user` ADD `total` decimal(15,6) NOT NULL AFTER `before_total`;
ALTER TABLE `user` ADD `auto_invoice` tinyint(1) NOT NULL DEFAULT '1' AFTER `total`;
ALTER TABLE `user` ADD `invoice_rate` tinyint(1) NOT NULL DEFAULT '1' AFTER `auto_invoice`;
ALTER TABLE `user` ADD `staff_id` int NOT NULL AFTER `invoice_rate`;
ALTER TABLE `user` ADD `edit_date` datetime NOT NULL AFTER `staff_id`;
ALTER TABLE `user` ADD `code1` varchar(50) NOT NULL AFTER `edit_date`;
ALTER TABLE `user` ADD `code2` varchar(50) NOT NULL AFTER `code1`;
ALTER TABLE `user` ADD `code3` varchar(50) NOT NULL