create table districts
(
    id              int auto_increment
        primary key,
    zone_id         int                  not null,
    country_id      int                  not null,
    shipping_status tinyint(1) default 1 not null,
    name            varchar(128)         not null,
    status          tinyint(1)           not null,
    code            int        default 0 not null
)
    charset = utf8;

create index country_id
    on districts (country_id);

create index zone_id
    on districts (zone_id);

INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1, 1, 215, 1, 'SEYHAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (2, 1, 215, 1, 'YÜREĞİR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (3, 1, 215, 1, 'ALADAĞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (4, 1, 215, 1, 'CEYHAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (5, 1, 215, 1, 'FEKE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (6, 1, 215, 1, 'İMAMOĞLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (7, 1, 215, 1, 'KARAİSALI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (8, 1, 215, 1, 'KARATAŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (9, 1, 215, 1, 'KOZAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (10, 1, 215, 1, 'POZANTI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (11, 1, 215, 1, 'SAİMBEYLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (12, 1, 215, 1, 'TUFANBEYLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (13, 1, 215, 1, 'YUMURTALIK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (14, 2, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (15, 2, 215, 1, 'BESNİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (16, 2, 215, 1, 'ÇELİKHAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (17, 2, 215, 1, 'GERGER', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (18, 2, 215, 1, 'GÖLBAŞI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (19, 2, 215, 1, 'KAHTA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (20, 2, 215, 1, 'SAMSAT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (21, 2, 215, 1, 'SİNCİK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (22, 2, 215, 1, 'TUT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (23, 3, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (24, 3, 215, 1, 'BAŞMAKÇI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (25, 3, 215, 1, 'BAYAT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (26, 3, 215, 1, 'BOLVADİN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (27, 3, 215, 1, 'ÇAY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (28, 3, 215, 1, 'ÇOBANLAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (29, 3, 215, 1, 'DAZKIRI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (30, 3, 215, 1, 'DİNAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (31, 3, 215, 1, 'EMİRDAĞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (32, 3, 215, 1, 'EVCİLER', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (33, 3, 215, 1, 'HOCALAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (34, 3, 215, 1, 'İHSANİYE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (35, 3, 215, 1, 'İSCEHİSAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (36, 3, 215, 1, 'KIZILÖREN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (37, 3, 215, 1, 'SANDIKLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (38, 3, 215, 1, 'SİNANPAŞA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (39, 3, 215, 1, 'SULTANDAĞI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (40, 3, 215, 1, 'ŞUHUT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (41, 4, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (42, 4, 215, 1, 'DİYADİN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (43, 4, 215, 1, 'DOĞUBAYAZIT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (44, 4, 215, 1, 'ELEŞKİRT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (45, 4, 215, 1, 'HAMUR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (46, 4, 215, 1, 'PATNOS', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (47, 4, 215, 1, 'TAŞLIÇAY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (48, 4, 215, 1, 'TUTAK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (49, 5, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (50, 5, 215, 1, 'GÖYNÜCEK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (51, 5, 215, 1, 'GÜMÜŞHACIKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (52, 5, 215, 1, 'HAMAMÖZÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (53, 5, 215, 1, 'MERZİFON', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (54, 5, 215, 1, 'SULUOVA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (55, 5, 215, 1, 'TAŞOVA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (56, 6, 215, 1, 'ALTINDAĞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (57, 6, 215, 1, 'ÇANKAYA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (58, 6, 215, 1, 'ETİMESGUT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (59, 6, 215, 1, 'GÖLBAŞI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (60, 6, 215, 1, 'KEÇİÖREN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (61, 6, 215, 1, 'MAMAK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (62, 6, 215, 1, 'SİNCAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (63, 6, 215, 1, 'YENİMAHALLE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (64, 6, 215, 1, 'AKYURT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (65, 6, 215, 1, 'AYAŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (66, 6, 215, 1, 'BALA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (67, 6, 215, 1, 'BEYPAZARI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (68, 6, 215, 1, 'ÇAMLIDERE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (69, 6, 215, 1, 'ÇUBUK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (70, 6, 215, 1, 'ELMADAĞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (71, 6, 215, 1, 'EVREN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (72, 6, 215, 1, 'GÜDÜL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (73, 6, 215, 1, 'HAYMANA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (74, 6, 215, 1, 'KALECİK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (75, 6, 215, 1, 'KAZAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (76, 6, 215, 1, 'KIZILCAHAMAM', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (77, 6, 215, 1, 'NALLIHAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (78, 6, 215, 1, 'POLATLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (79, 6, 215, 1, 'ŞEREFLİKOÇHİSAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (80, 7, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (81, 7, 215, 1, 'AKSEKİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (82, 7, 215, 1, 'ALANYA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (83, 7, 215, 1, 'ELMALI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (84, 7, 215, 1, 'FİNİKE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (85, 7, 215, 1, 'GAZİPAŞA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (86, 7, 215, 1, 'GÜNDOĞMUŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (87, 7, 215, 1, 'İBRADI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (88, 7, 215, 1, 'DEMRE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (89, 7, 215, 1, 'KAŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (90, 7, 215, 1, 'KEMER', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (91, 7, 215, 1, 'KORKUTELİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (92, 7, 215, 1, 'KUMLUCA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (93, 7, 215, 1, 'MANAVGAT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (94, 7, 215, 1, 'SERİK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (95, 8, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (96, 8, 215, 1, 'ARDANUÇ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (97, 8, 215, 1, 'ARHAVİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (98, 8, 215, 1, 'BORÇKA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (99, 8, 215, 1, 'HOPA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (100, 8, 215, 1, 'MURGUL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (101, 8, 215, 1, 'ŞAVŞAT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (102, 8, 215, 1, 'YUSUFELİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (103, 9, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (104, 9, 215, 1, 'BOZDOĞAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (105, 9, 215, 1, 'BUHARKENT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (106, 9, 215, 1, 'ÇİNE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (107, 9, 215, 1, 'DİDİM', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (108, 9, 215, 1, 'GERMENCİK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (109, 9, 215, 1, 'İNCİRLİOVA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (110, 9, 215, 1, 'KARACASU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (111, 9, 215, 1, 'KARPUZLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (112, 9, 215, 1, 'KOÇARLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (113, 9, 215, 1, 'KÖŞK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (114, 9, 215, 1, 'KUŞADASI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (115, 9, 215, 1, 'KUYUCAK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (116, 9, 215, 1, 'NAZİLLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (117, 9, 215, 1, 'SÖKE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (118, 9, 215, 1, 'SULTANHİSAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (119, 9, 215, 1, 'YENİPAZAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (120, 10, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (121, 10, 215, 1, 'AYVALIK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (122, 10, 215, 1, 'BALYA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (123, 10, 215, 1, 'BANDIRMA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (124, 10, 215, 1, 'BİGADİÇ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (125, 10, 215, 1, 'BURHANİYE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (126, 10, 215, 1, 'DURSUNBEY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (127, 10, 215, 1, 'EDREMİT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (128, 10, 215, 1, 'ERDEK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (129, 10, 215, 1, 'GÖMEÇ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (130, 10, 215, 1, 'GÖNEN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (131, 10, 215, 1, 'HAVRAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (132, 10, 215, 1, 'İVRİNDİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (133, 10, 215, 1, 'KEPSUT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (134, 10, 215, 1, 'MANYAS', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (135, 10, 215, 1, 'MARMARA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (136, 10, 215, 1, 'SAVAŞTEPE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (137, 10, 215, 1, 'SINDIRGI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (138, 10, 215, 1, 'SUSURLUK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (139, 11, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (140, 11, 215, 1, 'BOZÜYÜK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (141, 11, 215, 1, 'GÖLPAZARI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (142, 11, 215, 1, 'İNHİSAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (143, 11, 215, 1, 'OSMANELİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (144, 11, 215, 1, 'PAZARYERİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (145, 11, 215, 1, 'SÖĞÜT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (146, 11, 215, 1, 'YENİPAZAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (147, 12, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (148, 12, 215, 1, 'ADAKLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (149, 12, 215, 1, 'GENÇ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (150, 12, 215, 1, 'KARLIOVA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (151, 12, 215, 1, 'KİĞI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (152, 12, 215, 1, 'SOLHAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (153, 12, 215, 1, 'YAYLADERE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (154, 12, 215, 1, 'YEDİSU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (155, 13, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (156, 13, 215, 1, 'ADİLCEVAZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (157, 13, 215, 1, 'AHLAT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (158, 13, 215, 1, 'GÜROYMAK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (159, 13, 215, 1, 'HİZAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (160, 13, 215, 1, 'MUTKİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (161, 13, 215, 1, 'TATVAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (162, 14, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (163, 14, 215, 1, 'DÖRTDİVAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (164, 14, 215, 1, 'GEREDE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (165, 14, 215, 1, 'GÖYNÜK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (166, 14, 215, 1, 'KIBRISCIK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (167, 14, 215, 1, 'MENGEN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (168, 14, 215, 1, 'MUDURNU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (169, 14, 215, 1, 'SEBEN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (170, 14, 215, 1, 'YENİÇAĞA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (171, 15, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (172, 15, 215, 1, 'AĞLASUN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (173, 15, 215, 1, 'ALTINYAYLA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (174, 15, 215, 1, 'BUCAK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (175, 15, 215, 1, 'ÇAVDIR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (176, 15, 215, 1, 'ÇELTİKÇİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (177, 15, 215, 1, 'GÖLHİSAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (178, 15, 215, 1, 'KARAMANLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (179, 15, 215, 1, 'KEMER', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (180, 15, 215, 1, 'TEFENNİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (181, 15, 215, 1, 'YEŞİLOVA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (182, 16, 215, 1, 'NİLÜFER', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (183, 16, 215, 1, 'OSMANGAZİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (184, 16, 215, 1, 'YILDIRIM', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (185, 16, 215, 1, 'BÜYÜKORHAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (186, 16, 215, 1, 'GEMLİK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (187, 16, 215, 1, 'GÜRSU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (188, 16, 215, 1, 'HARMANCIK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (189, 16, 215, 1, 'İNEGÖL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (190, 16, 215, 1, 'İZNİK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (191, 16, 215, 1, 'KARACABEY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (192, 16, 215, 1, 'KELES', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (193, 16, 215, 1, 'KESTEL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (194, 16, 215, 1, 'MUDANYA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (195, 16, 215, 1, 'MUSTAFAKEMALPAŞA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (196, 16, 215, 1, 'ORHANELİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (197, 16, 215, 1, 'ORHANGAZİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (198, 16, 215, 1, 'YENİŞEHİR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (199, 17, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (200, 17, 215, 1, 'AYVACIK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (201, 17, 215, 1, 'BAYRAMİÇ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (202, 17, 215, 1, 'BİGA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (203, 17, 215, 1, 'BOZCAADA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (204, 17, 215, 1, 'ÇAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (205, 17, 215, 1, 'ECEABAT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (206, 17, 215, 1, 'EZİNE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (207, 17, 215, 1, 'GELİBOLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (208, 17, 215, 1, 'GÖKÇEADA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (209, 17, 215, 1, 'LAPSEKİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (210, 17, 215, 1, 'YENİCE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (211, 18, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (212, 18, 215, 1, 'ATKARACALAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (213, 18, 215, 1, 'BAYRAMÖREN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (214, 18, 215, 1, 'ÇERKEŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (215, 18, 215, 1, 'ELDİVAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (216, 18, 215, 1, 'ILGAZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (217, 18, 215, 1, 'KIZILIRMAK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (218, 18, 215, 1, 'KORGUN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (219, 18, 215, 1, 'KURŞUNLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (220, 18, 215, 1, 'ORTA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (221, 18, 215, 1, 'ŞABANÖZÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (222, 18, 215, 1, 'YAPRAKLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (223, 19, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (224, 19, 215, 1, 'ALACA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (225, 19, 215, 1, 'BAYAT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (226, 19, 215, 1, 'BOĞAZKALE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (227, 19, 215, 1, 'DODURGA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (228, 19, 215, 1, 'İSKİLİP', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (229, 19, 215, 1, 'KARGI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (230, 19, 215, 1, 'LAÇİN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (231, 19, 215, 1, 'MECİTÖZÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (232, 19, 215, 1, 'OĞUZLAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (233, 19, 215, 1, 'ORTAKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (234, 19, 215, 1, 'OSMANCIK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (235, 19, 215, 1, 'SUNGURLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (236, 19, 215, 1, 'UĞURLUDAĞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (237, 20, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (238, 20, 215, 1, 'ACIPAYAM', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (239, 20, 215, 1, 'AKKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (240, 20, 215, 1, 'BABADAĞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (241, 20, 215, 1, 'BAKLAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (243, 20, 215, 1, 'BEYAĞAÇ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (244, 20, 215, 1, 'BOZKURT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (245, 20, 215, 1, 'BULDAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (246, 20, 215, 1, 'ÇAL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (247, 20, 215, 1, 'ÇAMELİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (248, 20, 215, 1, 'ÇARDAK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (249, 20, 215, 1, 'ÇİVRİL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (250, 20, 215, 1, 'GÜNEY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (251, 20, 215, 1, 'HONAZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (252, 20, 215, 1, 'KALE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (253, 20, 215, 1, 'SARAYKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (254, 20, 215, 1, 'SERİNHİSAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (255, 20, 215, 1, 'TAVAS', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (256, 21, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (257, 21, 215, 1, 'BİSMİL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (258, 21, 215, 1, 'ÇERMİK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (259, 21, 215, 1, 'ÇINAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (260, 21, 215, 1, 'ÇÜNGÜŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (261, 21, 215, 1, 'DİCLE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (262, 21, 215, 1, 'EĞİL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (263, 21, 215, 1, 'ERGANİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (264, 21, 215, 1, 'HANİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (265, 21, 215, 1, 'HAZRO', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (266, 21, 215, 1, 'KOCAKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (267, 21, 215, 1, 'KULP', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (268, 21, 215, 1, 'LİCE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (269, 21, 215, 1, 'SİLVAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (270, 22, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (271, 22, 215, 1, 'ENEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (272, 22, 215, 1, 'HAVSA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (273, 22, 215, 1, 'İPSALA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (274, 22, 215, 1, 'KEŞAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (275, 22, 215, 1, 'LALAPAŞA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (276, 22, 215, 1, 'MERİÇ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (277, 22, 215, 1, 'SÜLOĞLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (278, 22, 215, 1, 'UZUNKÖPRÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (279, 23, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (280, 23, 215, 1, 'AĞIN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (281, 23, 215, 1, 'ALACAKAYA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (282, 23, 215, 1, 'ARICAK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (283, 23, 215, 1, 'BASKİL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (284, 23, 215, 1, 'KARAKOÇAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (285, 23, 215, 1, 'KEBAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (286, 23, 215, 1, 'KOVANCILAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (287, 23, 215, 1, 'MADEN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (288, 23, 215, 1, 'PALU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (289, 23, 215, 1, 'SİVRİCE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (290, 24, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (291, 24, 215, 1, 'ÇAYIRLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (292, 24, 215, 1, 'İLİÇ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (293, 24, 215, 1, 'KEMAH', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (294, 24, 215, 1, 'KEMALİYE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (295, 24, 215, 1, 'OTLUKBELİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (296, 24, 215, 1, 'REFAHİYE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (297, 24, 215, 1, 'TERCAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (298, 24, 215, 1, 'ÜZÜMLÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (299, 25, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (300, 25, 215, 1, 'AŞKALE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (301, 25, 215, 1, 'ÇAT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (302, 25, 215, 1, 'HINIS', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (303, 25, 215, 1, 'HORASAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (304, 25, 215, 1, 'AZİZİYE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (305, 25, 215, 1, 'İSPİR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (306, 25, 215, 1, 'KARAÇOBAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (307, 25, 215, 1, 'KARAYAZI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (308, 25, 215, 1, 'KÖPRÜKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (309, 25, 215, 1, 'NARMAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (310, 25, 215, 1, 'OLTU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (311, 25, 215, 1, 'OLUR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (312, 25, 215, 1, 'PASİNLER', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (313, 25, 215, 1, 'PAZARYOLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (314, 25, 215, 1, 'ŞENKAYA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (315, 25, 215, 1, 'TEKMAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (316, 25, 215, 1, 'TORTUM', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (317, 25, 215, 1, 'UZUNDERE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (318, 26, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (319, 26, 215, 1, 'ALPU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (320, 26, 215, 1, 'BEYLİKOVA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (321, 26, 215, 1, 'ÇİFTELER', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (322, 26, 215, 1, 'GÜNYÜZÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (323, 26, 215, 1, 'HAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (324, 26, 215, 1, 'İNÖNÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (325, 26, 215, 1, 'MAHMUDİYE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (326, 26, 215, 1, 'MİHALGAZİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (327, 26, 215, 1, 'MİHALICÇIK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (328, 26, 215, 1, 'SARICAKAYA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (329, 26, 215, 1, 'SEYİTGAZİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (330, 26, 215, 1, 'SİVRİHİSAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (331, 27, 215, 1, 'ŞAHİNBEY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (332, 27, 215, 1, 'ŞEHİTKAMİL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (333, 27, 215, 1, 'ARABAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (334, 27, 215, 1, 'İSLAHİYE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (335, 27, 215, 1, 'KARKAMIŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (336, 27, 215, 1, 'NİZİP', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (337, 27, 215, 1, 'NURDAĞI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (338, 27, 215, 1, 'OĞUZELİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (339, 27, 215, 1, 'YAVUZELİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (340, 28, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (341, 28, 215, 1, 'ALUCRA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (342, 28, 215, 1, 'BULANCAK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (343, 28, 215, 1, 'ÇAMOLUK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (344, 28, 215, 1, 'ÇANAKÇI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (345, 28, 215, 1, 'DERELİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (346, 28, 215, 1, 'DOĞANKENT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (347, 28, 215, 1, 'ESPİYE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (348, 28, 215, 1, 'EYNESİL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (349, 28, 215, 1, 'GÖRELE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (350, 28, 215, 1, 'GÜCE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (351, 28, 215, 1, 'KEŞAP', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (352, 28, 215, 1, 'PİRAZİZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (353, 28, 215, 1, 'ŞEBİNKARAHİSAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (354, 28, 215, 1, 'TİREBOLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (355, 28, 215, 1, 'YAĞLIDERE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (356, 29, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (357, 29, 215, 1, 'KELKİT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (358, 29, 215, 1, 'KÖSE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (359, 29, 215, 1, 'KÜRTÜN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (360, 29, 215, 1, 'ŞİRAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (361, 29, 215, 1, 'TORUL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (362, 30, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (363, 30, 215, 1, 'ÇUKURCA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (364, 30, 215, 1, 'ŞEMDİNLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (365, 30, 215, 1, 'YÜKSEKOVA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (366, 31, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (367, 31, 215, 1, 'ALTINÖZÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (368, 31, 215, 1, 'BELEN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (369, 31, 215, 1, 'DÖRTYOL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (370, 31, 215, 1, 'ERZİN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (371, 31, 215, 1, 'HASSA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (372, 31, 215, 1, 'İSKENDERUN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (373, 31, 215, 1, 'KIRIKHAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (374, 31, 215, 1, 'KUMLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (375, 31, 215, 1, 'REYHANLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (376, 31, 215, 1, 'SAMANDAĞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (377, 31, 215, 1, 'YAYLADAĞI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (378, 32, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (379, 32, 215, 1, 'AKSU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (380, 32, 215, 1, 'ATABEY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (381, 32, 215, 1, 'EĞİRDİR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (382, 32, 215, 1, 'GELENDOST', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (383, 32, 215, 1, 'GÖNEN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (384, 32, 215, 1, 'KEÇİBORLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (385, 32, 215, 1, 'SENİRKENT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (386, 32, 215, 1, 'SÜTÇÜLER', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (387, 32, 215, 1, 'ŞARKİKARAAĞAÇ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (388, 32, 215, 1, 'ULUBORLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (389, 32, 215, 1, 'YALVAÇ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (390, 32, 215, 1, 'YENİŞARBADEMLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (391, 33, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (392, 33, 215, 1, 'ANAMUR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (393, 33, 215, 1, 'AYDINCIK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (394, 33, 215, 1, 'BOZYAZI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (395, 33, 215, 1, 'ÇAMLIYAYLA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (396, 33, 215, 1, 'ERDEMLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (397, 33, 215, 1, 'GÜLNAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (398, 33, 215, 1, 'MUT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (399, 33, 215, 1, 'SİLİFKE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (400, 33, 215, 1, 'TARSUS', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (401, 34, 215, 1, 'ADALAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (402, 34, 215, 1, 'AVCILAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (403, 34, 215, 1, 'BAĞCILAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (404, 34, 215, 1, 'BAHÇELİEVLER', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (405, 34, 215, 1, 'BAKIRKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (406, 34, 215, 1, 'BAYRAMPAŞA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (407, 34, 215, 1, 'BEŞİKTAŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (408, 34, 215, 1, 'BEYKOZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (409, 34, 215, 1, 'BEYOĞLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (410, 34, 215, 1, 'EMİNÖNÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (411, 34, 215, 1, 'ESENLER', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (412, 34, 215, 1, 'EYÜP', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (413, 34, 215, 1, 'FATİH', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (414, 34, 215, 1, 'GAZİOSMANPAŞA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (415, 34, 215, 1, 'GÜNGÖREN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (416, 34, 215, 1, 'KADIKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (417, 34, 215, 1, 'KAĞITHANE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (418, 34, 215, 1, 'KARTAL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (419, 34, 215, 1, 'KÜÇÜKÇEKMECE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (420, 34, 215, 1, 'MALTEPE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (421, 34, 215, 1, 'PENDİK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (422, 34, 215, 1, 'SARIYER', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (423, 34, 215, 1, 'ŞİŞLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (424, 34, 215, 1, 'TUZLA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (425, 34, 215, 1, 'ÜMRANİYE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (426, 34, 215, 1, 'ÜSKÜDAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (427, 34, 215, 1, 'ZEYTİNBURNU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (428, 34, 215, 1, 'BÜYÜKÇEKMECE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (429, 34, 215, 1, 'ÇATALCA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (430, 34, 215, 1, 'SİLİVRİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (431, 34, 215, 1, 'SULTANBEYLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (432, 34, 215, 1, 'ŞİLE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (433, 35, 215, 1, 'BALÇOVA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (434, 35, 215, 1, 'BORNOVA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (435, 35, 215, 1, 'BUCA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (436, 35, 215, 1, 'ÇİĞLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (437, 35, 215, 1, 'GAZİEMİR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (438, 35, 215, 1, 'GÜZELBAHÇE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (439, 35, 215, 1, 'KARŞIYAKA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (440, 35, 215, 1, 'KONAK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (441, 35, 215, 1, 'NARLIDERE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (442, 35, 215, 1, 'ALİAĞA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (443, 35, 215, 1, 'BAYINDIR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (444, 35, 215, 1, 'BERGAMA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (445, 35, 215, 1, 'BEYDAĞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (446, 35, 215, 1, 'ÇEŞME', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (447, 35, 215, 1, 'DİKİLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (448, 35, 215, 1, 'FOÇA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (449, 35, 215, 1, 'KARABURUN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (450, 35, 215, 1, 'KEMALPAŞA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (451, 35, 215, 1, 'KINIK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (452, 35, 215, 1, 'KİRAZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (453, 35, 215, 1, 'MENDERES', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (454, 35, 215, 1, 'MENEMEN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (455, 35, 215, 1, 'ÖDEMİŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (456, 35, 215, 1, 'SEFERİHİSAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (457, 35, 215, 1, 'SELÇUK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (458, 35, 215, 1, 'TİRE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (459, 35, 215, 1, 'TORBALI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (460, 35, 215, 1, 'URLA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (461, 36, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (462, 36, 215, 1, 'AKYAKA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (463, 36, 215, 1, 'ARPAÇAY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (464, 36, 215, 1, 'DİGOR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (465, 36, 215, 1, 'KAĞIZMAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (466, 36, 215, 1, 'SARIKAMIŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (467, 36, 215, 1, 'SELİM', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (468, 36, 215, 1, 'SUSUZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (469, 37, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (470, 37, 215, 1, 'ABANA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (471, 37, 215, 1, 'AĞLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (472, 37, 215, 1, 'ARAÇ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (473, 37, 215, 1, 'AZDAVAY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (474, 37, 215, 1, 'BOZKURT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (475, 37, 215, 1, 'CİDE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (476, 37, 215, 1, 'ÇATALZEYTİN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (477, 37, 215, 1, 'DADAY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (478, 37, 215, 1, 'DEVREKANİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (479, 37, 215, 1, 'DOĞANYURT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (480, 37, 215, 1, 'HANÖNÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (481, 37, 215, 1, 'İHSANGAZİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (482, 37, 215, 1, 'İNEBOLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (483, 37, 215, 1, 'KÜRE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (484, 37, 215, 1, 'PINARBAŞI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (485, 37, 215, 1, 'SEYDİLER', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (486, 37, 215, 1, 'ŞENPAZAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (487, 37, 215, 1, 'TAŞKÖPRÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (488, 37, 215, 1, 'TOSYA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (489, 38, 215, 1, 'KOCASİNAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (490, 38, 215, 1, 'MELİKGAZİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (491, 38, 215, 1, 'AKKIŞLA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (492, 38, 215, 1, 'BÜNYAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (493, 38, 215, 1, 'DEVELİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (494, 38, 215, 1, 'FELAHİYE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (495, 38, 215, 1, 'HACILAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (496, 38, 215, 1, 'İNCESU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (497, 38, 215, 1, 'ÖZVATAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (498, 38, 215, 1, 'PINARBAŞI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (499, 38, 215, 1, 'SARIOĞLAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (500, 38, 215, 1, 'SARIZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (501, 38, 215, 1, 'TALAS', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (502, 38, 215, 1, 'TOMARZA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (503, 38, 215, 1, 'YAHYALI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (504, 38, 215, 1, 'YEŞİLHİSAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (505, 39, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (506, 39, 215, 1, 'BABAESKİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (507, 39, 215, 1, 'DEMİRKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (508, 39, 215, 1, 'KOFÇAZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (509, 39, 215, 1, 'LÜLEBURGAZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (510, 39, 215, 1, 'PEHLİVANKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (511, 39, 215, 1, 'PINARHİSAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (512, 39, 215, 1, 'VİZE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (513, 40, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (514, 40, 215, 1, 'AKÇAKENT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (515, 40, 215, 1, 'AKPINAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (516, 40, 215, 1, 'BOZTEPE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (517, 40, 215, 1, 'ÇİÇEKDAĞI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (518, 40, 215, 1, 'KAMAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (519, 40, 215, 1, 'MUCUR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (520, 41, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (521, 41, 215, 1, 'GEBZE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (522, 41, 215, 1, 'GÖLCÜK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (523, 41, 215, 1, 'KANDIRA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (524, 41, 215, 1, 'KARAMÜRSEL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (525, 41, 215, 1, 'KÖRFEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (526, 41, 215, 1, 'DERİNCE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (527, 42, 215, 1, 'KARATAY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (528, 42, 215, 1, 'MERAM', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (529, 42, 215, 1, 'SELÇUKLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (530, 42, 215, 1, 'AHIRLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (531, 42, 215, 1, 'AKÖREN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (532, 42, 215, 1, 'AKŞEHİR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (533, 42, 215, 1, 'ALTINEKİN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (534, 42, 215, 1, 'BEYŞEHİR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (535, 42, 215, 1, 'BOZKIR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (536, 42, 215, 1, 'CİHANBEYLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (537, 42, 215, 1, 'ÇELTİK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (538, 42, 215, 1, 'ÇUMRA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (539, 42, 215, 1, 'DERBENT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (540, 42, 215, 1, 'DEREBUCAK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (541, 42, 215, 1, 'DOĞANHİSAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (542, 42, 215, 1, 'EMİRGAZİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (543, 42, 215, 1, 'EREĞLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (544, 42, 215, 1, 'GÜNEYSINIR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (545, 42, 215, 1, 'HADİM', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (546, 42, 215, 1, 'HALKAPINAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (547, 42, 215, 1, 'HÜYÜK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (548, 42, 215, 1, 'ILGIN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (549, 42, 215, 1, 'KADINHANI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (550, 42, 215, 1, 'KARAPINAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (551, 42, 215, 1, 'KULU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (552, 42, 215, 1, 'SARAYÖNÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (553, 42, 215, 1, 'SEYDİŞEHİR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (554, 42, 215, 1, 'TAŞKENT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (555, 42, 215, 1, 'TUZLUKÇU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (556, 42, 215, 1, 'YALIHÜYÜK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (557, 42, 215, 1, 'YUNAK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (558, 43, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (559, 43, 215, 1, 'ALTINTAŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (560, 43, 215, 1, 'ASLANAPA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (561, 43, 215, 1, 'ÇAVDARHİSAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (562, 43, 215, 1, 'DOMANİÇ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (563, 43, 215, 1, 'DUMLUPINAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (564, 43, 215, 1, 'EMET', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (565, 43, 215, 1, 'GEDİZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (566, 43, 215, 1, 'HİSARCIK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (567, 43, 215, 1, 'PAZARLAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (568, 43, 215, 1, 'SİMAV', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (569, 43, 215, 1, 'ŞAPHANE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (570, 43, 215, 1, 'TAVŞANLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (571, 44, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (572, 44, 215, 1, 'AKÇADAĞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (573, 44, 215, 1, 'ARAPGİR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (574, 44, 215, 1, 'ARGUVAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (575, 44, 215, 1, 'BATTALGAZİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (576, 44, 215, 1, 'DARENDE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (577, 44, 215, 1, 'DOĞANŞEHİR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (578, 44, 215, 1, 'DOĞANYOL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (579, 44, 215, 1, 'HEKİMHAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (580, 44, 215, 1, 'KALE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (581, 44, 215, 1, 'KULUNCAK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (582, 44, 215, 1, 'PÜTÜRGE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (583, 44, 215, 1, 'YAZIHAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (584, 44, 215, 1, 'YEŞİLYURT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (585, 45, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (586, 45, 215, 1, 'AHMETLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (587, 45, 215, 1, 'AKHİSAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (588, 45, 215, 1, 'ALAŞEHİR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (589, 45, 215, 1, 'DEMİRCİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (590, 45, 215, 1, 'GÖLMARMARA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (591, 45, 215, 1, 'GÖRDES', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (592, 45, 215, 1, 'KIRKAĞAÇ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (593, 45, 215, 1, 'KÖPRÜBAŞI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (594, 45, 215, 1, 'KULA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (595, 45, 215, 1, 'SALİHLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (596, 45, 215, 1, 'SARIGÖL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (597, 45, 215, 1, 'SARUHANLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (598, 45, 215, 1, 'SELENDİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (599, 45, 215, 1, 'SOMA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (600, 45, 215, 1, 'TURGUTLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (601, 46, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (602, 46, 215, 1, 'AFŞİN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (603, 46, 215, 1, 'ANDIRIN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (604, 46, 215, 1, 'ÇAĞLAYANCERİT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (605, 46, 215, 1, 'EKİNÖZÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (606, 46, 215, 1, 'ELBİSTAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (607, 46, 215, 1, 'GÖKSUN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (608, 46, 215, 1, 'NURHAK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (609, 46, 215, 1, 'PAZARCIK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (610, 46, 215, 1, 'TÜRKOĞLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (611, 47, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (612, 47, 215, 1, 'DARGEÇİT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (613, 47, 215, 1, 'DERİK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (614, 47, 215, 1, 'KIZILTEPE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (615, 47, 215, 1, 'MAZIDAĞI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (616, 47, 215, 1, 'MİDYAT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (617, 47, 215, 1, 'NUSAYBİN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (618, 47, 215, 1, 'ÖMERLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (619, 47, 215, 1, 'SAVUR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (620, 47, 215, 1, 'YEŞİLLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (621, 48, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (622, 48, 215, 1, 'BODRUM', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (623, 48, 215, 1, 'DALAMAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (624, 48, 215, 1, 'DATÇA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (625, 48, 215, 1, 'FETHİYE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (626, 48, 215, 1, 'KAVAKLIDERE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (627, 48, 215, 1, 'KÖYCEĞİZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (628, 48, 215, 1, 'MARMARİS', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (629, 48, 215, 1, 'MİLAS', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (630, 48, 215, 1, 'ORTACA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (631, 48, 215, 1, 'ULA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (632, 48, 215, 1, 'YATAĞAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (633, 49, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (634, 49, 215, 1, 'BULANIK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (635, 49, 215, 1, 'HASKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (636, 49, 215, 1, 'KORKUT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (637, 49, 215, 1, 'MALAZGİRT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (638, 49, 215, 1, 'VARTO', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (639, 50, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (640, 50, 215, 1, 'ACIGÖL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (641, 50, 215, 1, 'AVANOS', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (642, 50, 215, 1, 'DERİNKUYU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (643, 50, 215, 1, 'GÜLŞEHİR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (644, 50, 215, 1, 'HACIBEKTAŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (645, 50, 215, 1, 'KOZAKLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (646, 50, 215, 1, 'ÜRGÜP', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (647, 51, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (648, 51, 215, 1, 'ALTUNHİSAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (649, 51, 215, 1, 'BOR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (650, 51, 215, 1, 'ÇAMARDI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (651, 51, 215, 1, 'ÇİFTLİK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (652, 51, 215, 1, 'ULUKIŞLA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (653, 52, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (654, 52, 215, 1, 'AKKUŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (655, 52, 215, 1, 'AYBASTI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (656, 52, 215, 1, 'ÇAMAŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (657, 52, 215, 1, 'ÇATALPINAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (658, 52, 215, 1, 'ÇAYBAŞI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (659, 52, 215, 1, 'FATSA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (660, 52, 215, 1, 'GÖLKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (661, 52, 215, 1, 'GÜLYALI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (662, 52, 215, 1, 'GÜRGENTEPE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (663, 52, 215, 1, 'İKİZCE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (664, 52, 215, 1, 'KABADÜZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (665, 52, 215, 1, 'KABATAŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (666, 52, 215, 1, 'KORGAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (667, 52, 215, 1, 'KUMRU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (668, 52, 215, 1, 'MESUDİYE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (669, 52, 215, 1, 'PERŞEMBE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (670, 52, 215, 1, 'ULUBEY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (671, 52, 215, 1, 'ÜNYE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (672, 53, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (673, 53, 215, 1, 'ARDEŞEN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (674, 53, 215, 1, 'ÇAMLIHEMŞİN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (675, 53, 215, 1, 'ÇAYELİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (676, 53, 215, 1, 'DEREPAZARI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (677, 53, 215, 1, 'FINDIKLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (678, 53, 215, 1, 'GÜNEYSU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (679, 53, 215, 1, 'HEMŞİN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (680, 53, 215, 1, 'İKİZDERE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (681, 53, 215, 1, 'İYİDERE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (682, 53, 215, 1, 'KALKANDERE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (683, 53, 215, 1, 'PAZAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (684, 54, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (685, 54, 215, 1, 'FERİZLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (686, 54, 215, 1, 'SÖĞÜTLÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (687, 54, 215, 1, 'AKYAZI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (688, 54, 215, 1, 'GEYVE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (689, 54, 215, 1, 'HENDEK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (690, 54, 215, 1, 'KARAPÜRÇEK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (691, 54, 215, 1, 'KARASU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (692, 54, 215, 1, 'KAYNARCA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (693, 54, 215, 1, 'KOCAALİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (694, 54, 215, 1, 'PAMUKOVA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (695, 54, 215, 1, 'SAPANCA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (696, 54, 215, 1, 'TARAKLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (697, 55, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (698, 55, 215, 1, 'ALAÇAM', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (700, 55, 215, 1, 'AYVACIK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (701, 55, 215, 1, 'BAFRA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (702, 55, 215, 1, 'ÇARŞAMBA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (703, 55, 215, 1, 'HAVZA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (704, 55, 215, 1, 'KAVAK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (705, 55, 215, 1, 'LADİK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (706, 55, 215, 1, 'ONDOKUZMAYIS', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (707, 55, 215, 1, 'SALIPAZARI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (708, 55, 215, 1, 'TEKKEKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (709, 55, 215, 1, 'TERME', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (710, 55, 215, 1, 'VEZİRKÖPRÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (711, 55, 215, 1, 'YAKAKENT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (712, 56, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (713, 56, 215, 1, 'AYDINLAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (714, 56, 215, 1, 'BAYKAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (715, 56, 215, 1, 'ERUH', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (716, 56, 215, 1, 'KURTALAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (717, 56, 215, 1, 'PERVARİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (718, 56, 215, 1, 'ŞİRVAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (719, 57, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (720, 57, 215, 1, 'AYANCIK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (721, 57, 215, 1, 'BOYABAT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (722, 57, 215, 1, 'DİKMEN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (723, 57, 215, 1, 'DURAĞAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (724, 57, 215, 1, 'ERFELEK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (725, 57, 215, 1, 'GERZE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (726, 57, 215, 1, 'SARAYDÜZÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (727, 57, 215, 1, 'TÜRKELİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (728, 58, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (729, 58, 215, 1, 'AKINCILAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (730, 58, 215, 1, 'ALTINYAYLA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (731, 58, 215, 1, 'DİVRİĞİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (732, 58, 215, 1, 'DOĞANŞAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (733, 58, 215, 1, 'GEMEREK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (734, 58, 215, 1, 'GÖLOVA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (735, 58, 215, 1, 'GÜRÜN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (736, 58, 215, 1, 'HAFİK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (737, 58, 215, 1, 'İMRANLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (738, 58, 215, 1, 'KANGAL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (739, 58, 215, 1, 'KOYULHİSAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (740, 58, 215, 1, 'SUŞEHRİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (741, 58, 215, 1, 'ŞARKIŞLA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (742, 58, 215, 1, 'ULAŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (743, 58, 215, 1, 'YILDIZELİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (744, 58, 215, 1, 'ZARA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (745, 59, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (746, 59, 215, 1, 'ÇERKEZKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (747, 59, 215, 1, 'ÇORLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (748, 59, 215, 1, 'HAYRABOLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (749, 59, 215, 1, 'MALKARA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (750, 59, 215, 1, 'MARMARAEREĞLİSİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (751, 59, 215, 1, 'MURATLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (752, 59, 215, 1, 'SARAY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (753, 59, 215, 1, 'ŞARKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (754, 60, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (755, 60, 215, 1, 'ALMUS', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (756, 60, 215, 1, 'ARTOVA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (757, 60, 215, 1, 'BAŞÇİFTLİK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (758, 60, 215, 1, 'ERBAA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (759, 60, 215, 1, 'NİKSAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (760, 60, 215, 1, 'PAZAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (761, 60, 215, 1, 'REŞADİYE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (762, 60, 215, 1, 'SULUSARAY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (763, 60, 215, 1, 'TURHAL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (764, 60, 215, 1, 'YEŞİLYURT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (765, 60, 215, 1, 'ZİLE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (766, 61, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (767, 61, 215, 1, 'AKÇAABAT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (768, 61, 215, 1, 'ARAKLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (769, 61, 215, 1, 'ARSİN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (770, 61, 215, 1, 'BEŞİKDÜZÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (771, 61, 215, 1, 'ÇARŞIBAŞI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (772, 61, 215, 1, 'ÇAYKARA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (773, 61, 215, 1, 'DERNEKPAZARI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (774, 61, 215, 1, 'DÜZKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (775, 61, 215, 1, 'HAYRAT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (776, 61, 215, 1, 'KÖPRÜBAŞI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (777, 61, 215, 1, 'MAÇKA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (778, 61, 215, 1, 'OF', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (779, 61, 215, 1, 'SÜRMENE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (780, 61, 215, 1, 'ŞALPAZARI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (781, 61, 215, 1, 'TONYA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (782, 61, 215, 1, 'VAKFIKEBİR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (783, 61, 215, 1, 'YOMRA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (784, 62, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (785, 62, 215, 1, 'ÇEMİŞGEZEK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (786, 62, 215, 1, 'HOZAT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (787, 62, 215, 1, 'MAZGİRT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (788, 62, 215, 1, 'NAZIMİYE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (789, 62, 215, 1, 'OVACIK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (790, 62, 215, 1, 'PERTEK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (791, 62, 215, 1, 'PÜLÜMÜR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (792, 63, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (793, 63, 215, 1, 'AKÇAKALE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (794, 63, 215, 1, 'BİRECİK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (795, 63, 215, 1, 'BOZOVA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (796, 63, 215, 1, 'CEYLANPINAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (797, 63, 215, 1, 'HALFETİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (798, 63, 215, 1, 'HARRAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (799, 63, 215, 1, 'HİLVAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (800, 63, 215, 1, 'SİVEREK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (801, 63, 215, 1, 'SURUÇ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (802, 63, 215, 1, 'VİRANŞEHİR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (803, 64, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (804, 64, 215, 1, 'BANAZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (805, 64, 215, 1, 'EŞME', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (806, 64, 215, 1, 'KARAHALLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (807, 64, 215, 1, 'SİVASLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (808, 64, 215, 1, 'ULUBEY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (809, 65, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (810, 65, 215, 1, 'BAHÇESARAY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (811, 65, 215, 1, 'BAŞKALE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (812, 65, 215, 1, 'ÇALDIRAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (813, 65, 215, 1, 'ÇATAK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (814, 65, 215, 1, 'EDREMİT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (815, 65, 215, 1, 'ERCİŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (816, 65, 215, 1, 'GEVAŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (817, 65, 215, 1, 'GÜRPINAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (818, 65, 215, 1, 'MURADİYE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (819, 65, 215, 1, 'ÖZALP', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (820, 65, 215, 1, 'SARAY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (821, 66, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (822, 66, 215, 1, 'AKDAĞMADENİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (823, 66, 215, 1, 'AYDINCIK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (824, 66, 215, 1, 'BOĞAZLIYAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (825, 66, 215, 1, 'ÇANDIR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (826, 66, 215, 1, 'ÇAYIRALAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (827, 66, 215, 1, 'ÇEKEREK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (828, 66, 215, 1, 'KADIŞEHRİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (829, 66, 215, 1, 'SARAYKENT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (830, 66, 215, 1, 'SARIKAYA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (831, 66, 215, 1, 'SORGUN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (832, 66, 215, 1, 'ŞEFAATLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (833, 66, 215, 1, 'YENİFAKILI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (834, 66, 215, 1, 'YERKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (835, 67, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (836, 67, 215, 1, 'ALAPLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (837, 67, 215, 1, 'ÇAYCUMA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (838, 67, 215, 1, 'DEVREK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (839, 67, 215, 1, 'EREĞLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (840, 67, 215, 1, 'GÖKÇEBEY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (841, 68, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (842, 68, 215, 1, 'AĞAÇÖREN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (843, 68, 215, 1, 'ESKİL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (844, 68, 215, 1, 'GÜLAĞAÇ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (845, 68, 215, 1, 'GÜZELYURT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (846, 68, 215, 1, 'ORTAKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (847, 68, 215, 1, 'SARIYAHŞİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (848, 69, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (849, 69, 215, 1, 'AYDINTEPE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (850, 69, 215, 1, 'DEMİRÖZÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (851, 70, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (852, 70, 215, 1, 'AYRANCI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (853, 70, 215, 1, 'BAŞYAYLA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (854, 70, 215, 1, 'ERMENEK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (855, 70, 215, 1, 'KAZIMKARABEKİR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (856, 70, 215, 1, 'SARIVELİLER', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (857, 71, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (858, 71, 215, 1, 'BAHŞİLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (859, 71, 215, 1, 'BALIŞEYH', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (860, 71, 215, 1, 'ÇELEBİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (861, 71, 215, 1, 'DELİCE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (862, 71, 215, 1, 'KARAKEÇİLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (863, 71, 215, 1, 'KESKİN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (864, 71, 215, 1, 'SULAKYURT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (865, 71, 215, 1, 'YAHŞİHAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (866, 72, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (867, 72, 215, 1, 'BEŞİRİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (868, 72, 215, 1, 'GERCÜŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (869, 72, 215, 1, 'HASANKEYF', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (870, 72, 215, 1, 'KOZLUK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (871, 72, 215, 1, 'SASON', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (872, 73, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (873, 73, 215, 1, 'BEYTÜŞŞEBAP', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (874, 73, 215, 1, 'CİZRE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (875, 73, 215, 1, 'GÜÇLÜKONAK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (876, 73, 215, 1, 'İDİL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (877, 73, 215, 1, 'SİLOPİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (878, 73, 215, 1, 'ULUDERE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (879, 74, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (880, 74, 215, 1, 'AMASRA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (881, 74, 215, 1, 'KURUCAŞİLE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (882, 74, 215, 1, 'ULUS', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (883, 75, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (884, 75, 215, 1, 'ÇILDIR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (885, 75, 215, 1, 'DAMAL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (886, 75, 215, 1, 'GÖLE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (887, 75, 215, 1, 'HANAK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (888, 75, 215, 1, 'POSOF', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (889, 76, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (890, 76, 215, 1, 'ARALIK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (891, 76, 215, 1, 'KARAKOYUNLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (892, 76, 215, 1, 'TUZLUCA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (893, 77, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (894, 77, 215, 1, 'ALTINOVA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (895, 77, 215, 1, 'ARMUTLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (896, 77, 215, 1, 'ÇINARCIK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (897, 77, 215, 1, 'ÇİFTLİKKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (898, 77, 215, 1, 'TERMAL', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (899, 78, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (900, 78, 215, 1, 'EFLANİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (901, 78, 215, 1, 'ESKİPAZAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (902, 78, 215, 1, 'OVACIK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (903, 78, 215, 1, 'SAFRANBOLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (904, 78, 215, 1, 'YENİCE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (905, 79, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (906, 79, 215, 1, 'ELBEYLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (907, 79, 215, 1, 'MUSABEYLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (908, 79, 215, 1, 'POLATELİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (909, 80, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (910, 80, 215, 1, 'BAHÇE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (911, 80, 215, 1, 'DÜZİÇİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (912, 80, 215, 1, 'HASANBEYLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (913, 80, 215, 1, 'KADİRLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (914, 80, 215, 1, 'SUMBAS', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (915, 80, 215, 1, 'TOPRAKKALE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (916, 81, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (917, 81, 215, 1, 'AKÇAKOCA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (918, 81, 215, 1, 'CUMAYERİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (919, 81, 215, 1, 'ÇİLİMLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (920, 81, 215, 1, 'GÖLYAKA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (921, 81, 215, 1, 'GÜMÜŞOVA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (922, 81, 215, 1, 'KAYNAŞLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (923, 81, 215, 1, 'YIĞILCA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (928, 7, 215, 1, 'MURATPAŞA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (929, 21, 215, 1, 'BAĞLAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (930, 7, 215, 1, 'KEPEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (931, 7, 215, 1, 'KONYAALTI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (932, 21, 215, 1, 'KAYAPINAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (933, 21, 215, 1, 'SUR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (935, 1, 215, 1, 'SARIÇAM', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (936, 1, 215, 1, 'ÇUKUROVA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (937, 6, 215, 1, 'PURSAKLAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (938, 7, 215, 1, 'AKSU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (939, 7, 215, 1, 'DÖŞEMEALTI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (940, 21, 215, 1, 'YENİŞEHİR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (941, 25, 215, 1, 'PALANDÖKEN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (942, 25, 215, 1, 'YAKUTİYE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (943, 26, 215, 1, 'ODUNPAZARI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (944, 26, 215, 1, 'TEPEBAŞI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (945, 34, 215, 1, 'ARNAVUTKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (946, 34, 215, 1, 'ATAŞEHİR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (947, 34, 215, 1, 'BAŞAKŞEHİR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (948, 34, 215, 1, 'BEYLİKDÜZÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (949, 34, 215, 1, 'ÇEKMEKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (950, 34, 215, 1, 'ESENYURT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (951, 34, 215, 1, 'SANCAKTEPE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (952, 34, 215, 1, 'SULTANGAZİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (953, 35, 215, 1, 'BAYRAKLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (954, 35, 215, 1, 'KARABAĞLAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (955, 41, 215, 1, 'BAŞİSKELE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (956, 41, 215, 1, 'ÇAYIROVA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (957, 41, 215, 1, 'DARICA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (958, 41, 215, 1, 'DİLOVASI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (959, 41, 215, 1, 'İZMİT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (960, 41, 215, 1, 'KARTEPE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (961, 33, 215, 1, 'AKDENİZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (962, 33, 215, 1, 'MEZİTLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (963, 33, 215, 1, 'TOROSLAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (964, 33, 215, 1, 'YENİŞEHİR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (965, 55, 215, 1, 'ATAKUM', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (966, 55, 215, 1, 'CANİK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (967, 55, 215, 1, 'İLKADIM', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (968, 54, 215, 1, 'ADAPAZARI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (969, 54, 215, 1, 'ARİFİYE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (970, 54, 215, 1, 'ERENLER', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (971, 54, 215, 1, 'SERDİVAN', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1939, 55, 215, 1, 'Asarcık', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1940, 65, 215, 1, 'İPEKYOLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1941, 31, 215, 1, 'ANTAKYA', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1942, 59, 215, 1, 'KAPAKLI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1943, 9, 215, 1, 'EFELER', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1944, 85, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1945, 63, 215, 1, 'HALİLİYE ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1946, 85, 215, 1, 'PAMUKKALE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1947, 48, 215, 1, 'SEYDİKEMER', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1949, 17, 215, 1, 'KEPEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1950, 31, 215, 1, 'defne', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1951, 31, 215, 1, 'DEFNE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1952, 27, 215, 1, 'GAZİKANT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1953, 31, 215, 1, 'PAYAS', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1954, 47, 215, 1, 'ARTUKLU ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1955, 34, 215, 1, 'ÜMRANİYE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1956, 48, 215, 1, 'MARMARİS', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1957, 46, 215, 1, 'DULKADİROĞLU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1958, 33, 215, 1, 'KAZANLI', 0, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1959, 35, 215, 1, 'TORBALI', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1960, 85, 215, 1, 'KALE', 0, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1963, 0, 0, 1, '', 0, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1964, 85, 215, 1, 'BEKİLLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1965, 34, 215, 1, 'İKİTELLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1966, 63, 215, 1, 'KARAKÖPRÜ', 0, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1967, 61, 215, 1, 'ORTAHİSAR', 0, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1968, 10, 215, 1, '6 EYLÜL', 0, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1969, 6, 215, 1, 'YENİKENT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1970, 85, 215, 1, 'MERKEZ EFENDİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1971, 85, 215, 1, 'SERİNHİSAR', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1972, 31, 215, 1, 'ARSUZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1973, 10, 215, 1, 'KARESİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1974, 45, 215, 1, 'YUNUSEMRE ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1975, 6, 215, 1, 'BATIKENT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1976, 45, 215, 1, 'ŞEHZADELER', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1977, 52, 215, 1, 'ALTINORDU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1978, 27, 215, 1, 'KARŞIYAKA', 0, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1979, 7, 215, 1, 'KAŞ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1980, 63, 215, 1, 'BİRECİK', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1981, 59, 215, 1, 'SÜLEYMANPAŞA', 0, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1982, 61, 215, 1, 'ÇUKURÇAYIR', 0, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1983, 53, 215, 1, 'MERKEZ ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1984, 16, 215, 1, 'YILDIRIM', 0, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1985, 85, 215, 1, 'GÜNEY', 0, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1986, 63, 215, 1, 'EYYUBİYE ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1987, 85, 215, 1, 'ACIPAYAM', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1988, 10, 215, 1, 'ERDEMİT', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1989, 67, 215, 1, 'KİLİMLİ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1990, 85, 215, 1, 'SARAYKÖY', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1991, 59, 215, 1, 'ERGENE', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1992, 6, 215, 1, 'DEMETEVLER ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1993, 59, 215, 1, 'ERGENE', 0, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1994, 65, 215, 1, 'TUŞBA', 0, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1995, 56, 215, 1, 'TİLLO', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1996, 55, 215, 1, '19 MAYIS', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1997, 61, 215, 1, 'BEŞİRLİ', 0, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1998, 35, 215, 1, 'ÇAMDİBİ', 0, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (1999, 49, 215, 1, 'HASKÖY', 0, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (2000, 61, 215, 1, 'MERKEZ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (2001, 35, 215, 1, 'ŞİRİNYER', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (2002, 77, 215, 1, 'TAŞKÖPRÜ', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (2003, 23, 215, 1, 'PALU', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (2004, 86, 2, 1, 'sadasd', 1, 0);
INSERT INTO districts (id, zone_id, country_id, shipping_status, name, status, code) VALUES (2005, 67, 215, 1, 'KOZLU', 1, 0);
