CREATE TABLE domains (
                         id INT AUTO_INCREMENT PRIMARY KEY,
                         customer_id INT,
                         name VARCHAR(255) NOT NULL,
                         renewal_date DATE,
                         price DECIMAL(10, 2),
                         created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                         updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                         FOREIGN KEY (customer_id) REFERENCES user(id)
);

CREATE TABLE hosts (
                       id INT AUTO_INCREMENT PRIMARY KEY,
                       customer_id INT,
                       name VARCHAR(255) NOT NULL,
                       ip_address VARCHAR(45) NOT NULL,
                       renewal_date DATE,
                       price DECIMAL(10, 2),
                       created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                       updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                       FOREIGN KEY (customer_id) REFERENCES user(id)
);

ALTER TABLE domains ADD COLUMN currency_id int NOT NULL DEFAULT 0;
ALTER TABLE hosts ADD COLUMN currency_id int NOT NULL DEFAULT 0;